/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.Serializable;

public class ModeUniversal
extends Mode
implements Storable,
Serializable {
    public ModeUniversal() {
    }

    public ModeUniversal(int logoMode) {
        this.setLogoMode(logoMode);
    }

    private void calcDays() {
        int[] tempArr = new int[7];
        int dayCount = 0;
        for (int i = 0; i < 7; ++i) {
            int onOff = this.fLogoMode & 1 << i;
            if (onOff <= 0) continue;
            tempArr[dayCount++] = i + 1;
        }
        this.fDays = new int[dayCount];
        System.arraycopy(tempArr, 0, this.fDays, 0, dayCount);
    }

    private void calcLogoMode() {
        int logoMode = 0;
        for (int i = 0; i < this.fDays.length; ++i) {
            logoMode |= 1 << this.fDays[i] - 1;
        }
        this.setLogoMode(logoMode);
    }

    public String getAbbreviation() {
        char[] abbreviations = new char[]{'M', 'T', 'W', 'T', 'F', 'S', 'S'};
        int[] days = this.getDays();
        StringBuffer res = new StringBuffer("-------");
        for (int i = 0; i < days.length; ++i) {
            int offset = days[i];
            offset = offset == 1 ? 6 : (offset -= 2);
            res.setCharAt(offset, abbreviations[offset]);
        }
        return res.toString();
    }

    public boolean isPredefinedMode() {
        switch (this.getLogoMode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 62: 
            case 64: 
            case 65: 
            case 126: 
            case 127: {
                return true;
            }
        }
        return false;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.calcLogoMode();
    }

    public void setDays(int[] days) {
        this.fDays = days;
        this.calcLogoMode();
    }

    public void setLogoMode(int logoMode) {
        this.fLogoMode = logoMode;
        this.calcDays();
    }

    public String toString() {
        String res = "";
        StringBuffer buffer = new StringBuffer();
        String[] names = new String[]{Language.getString("dialog.parameter.cam.sunday", "Sunday"), Language.getString("dialog.parameter.cam.monday", "Monday"), Language.getString("dialog.parameter.cam.tuesday", "Tuesday"), Language.getString("dialog.parameter.cam.wednesday", "Wednesday"), Language.getString("dialog.parameter.cam.thursday", "Thursday"), Language.getString("dialog.parameter.cam.friday", "Friday"), Language.getString("dialog.parameter.cam.saturday", "Saturday")};
        if (this.fDays.length > 0) {
            for (int i = 0; i < this.fDays.length; ++i) {
                buffer.append(',').append(names[this.fDays[i] - 1]);
            }
            res = buffer.substring(1, buffer.length());
        }
        if (res.length() == 0) {
            res = "No day selected";
        }
        return res;
    }
}

